/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.format;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.html.CellAlignment;
import icyllis.flexmark.util.misc.Utils;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.PrefixedSubSequence;

public class TableCell {
    public static final TableCell NULL = new TableCell(null, BasedSequence.NULL, " ", BasedSequence.NULL, 1, 0, CellAlignment.NONE);
    public static final TableCell DEFAULT_CELL = new TableCell(null, BasedSequence.NULL, " ", BasedSequence.NULL, 1, 1, CellAlignment.NONE);
    public static final int NOT_TRACKED = Integer.MAX_VALUE;
    public final Node tableCellNode;
    public final BasedSequence openMarker;
    public final BasedSequence text;
    public final BasedSequence closeMarker;
    public final int columnSpan;
    public final int rowSpan;
    public final CellAlignment alignment;
    public final int trackedTextOffset;
    public final int spanTrackedOffset;
    public final int trackedTextAdjust;
    public final boolean afterSpace;
    public final boolean afterDelete;

    public TableCell(CharSequence text, int rowSpan, int columnSpan) {
        this(null, BasedSequence.NULL, text, BasedSequence.NULL, rowSpan, columnSpan, CellAlignment.NONE);
    }

    public TableCell(Node tableCellNode, CharSequence text, int rowSpan, int columnSpan, CellAlignment alignment) {
        this(tableCellNode, BasedSequence.NULL, text, BasedSequence.NULL, rowSpan, columnSpan, alignment);
    }

    public TableCell(Node tableCellNode, CharSequence openMarker, CharSequence text, CharSequence closeMarker, int rowSpan, int columnSpan) {
        this(tableCellNode, openMarker, text, closeMarker, rowSpan, columnSpan, CellAlignment.NONE);
    }

    public TableCell(Node tableCellNode, CharSequence openMarker, CharSequence text, CharSequence closeMarker, int rowSpan, int columnSpan, CellAlignment alignment) {
        this(tableCellNode, openMarker, text, closeMarker, rowSpan, columnSpan, alignment, Integer.MAX_VALUE, Integer.MAX_VALUE, 0, false, false);
    }

    public TableCell(Node tableCellNode, CharSequence openMarker, CharSequence text, CharSequence closeMarker, int rowSpan, int columnSpan, CellAlignment alignment, int trackedTextOffset, int spanTrackedOffset, int trackedTextAdjust, boolean afterSpace, boolean afterDelete) {
        BasedSequence chars = BasedSequence.of(text);
        this.tableCellNode = tableCellNode;
        this.openMarker = BasedSequence.of(openMarker);
        this.closeMarker = BasedSequence.of(closeMarker);
        BasedSequence useMarker = this.openMarker.isEmpty() ? this.closeMarker.subSequence(0, 0) : (BasedSequence)this.openMarker.subSequence(this.openMarker.length());
        this.text = chars.isEmpty() && chars != BasedSequence.NULL ? PrefixedSubSequence.prefixOf(" ", useMarker) : chars;
        this.rowSpan = rowSpan;
        this.columnSpan = columnSpan;
        this.alignment = alignment != null ? alignment : CellAlignment.NONE;
        this.trackedTextOffset = trackedTextOffset;
        this.spanTrackedOffset = spanTrackedOffset;
        this.trackedTextAdjust = trackedTextAdjust;
        this.afterSpace = afterSpace;
        this.afterDelete = afterDelete;
    }

    public TableCell(@NotNull TableCell other, boolean copyNode, int rowSpan, int columnSpan, CellAlignment alignment) {
        this.tableCellNode = copyNode ? other.tableCellNode : null;
        this.openMarker = other.openMarker;
        this.closeMarker = other.closeMarker;
        BasedSequence useMarker = this.openMarker.isEmpty() ? this.closeMarker.subSequence(0, 0) : (BasedSequence)this.openMarker.subSequence(this.openMarker.length());
        this.text = other.text == BasedSequence.NULL ? PrefixedSubSequence.prefixOf(" ", useMarker) : other.text;
        this.rowSpan = rowSpan;
        this.columnSpan = columnSpan;
        this.alignment = alignment != null ? alignment : CellAlignment.NONE;
        this.trackedTextOffset = other.trackedTextOffset;
        this.spanTrackedOffset = other.spanTrackedOffset;
        this.trackedTextAdjust = other.trackedTextAdjust;
        this.afterSpace = other.afterSpace;
        this.afterDelete = other.afterDelete;
    }

    public TableCell withColumnSpan(int columnSpan) {
        return new TableCell(this.tableCellNode, this.openMarker, this.text, this.closeMarker, this.rowSpan, columnSpan, this.alignment, this.trackedTextOffset, this.spanTrackedOffset == Integer.MAX_VALUE ? Integer.MAX_VALUE : Utils.min(this.spanTrackedOffset, columnSpan), this.trackedTextAdjust, this.afterSpace, this.afterDelete);
    }

    public TableCell withText(CharSequence text) {
        return new TableCell(this.tableCellNode, this.openMarker, text, this.closeMarker, this.rowSpan, this.columnSpan, this.alignment, Integer.MAX_VALUE, this.spanTrackedOffset, this.trackedTextAdjust, this.afterSpace, this.afterDelete);
    }

    public TableCell withText(CharSequence openMarker, CharSequence text, CharSequence closeMarker) {
        return new TableCell(this.tableCellNode, openMarker, text, closeMarker, this.rowSpan, this.columnSpan, this.alignment, Integer.MAX_VALUE, this.spanTrackedOffset, this.trackedTextAdjust, this.afterSpace, this.afterDelete);
    }

    public TableCell withRowSpan(int rowSpan) {
        return new TableCell(this.tableCellNode, this.openMarker, this.text, this.closeMarker, rowSpan, this.columnSpan, this.alignment, this.trackedTextOffset, this.spanTrackedOffset, this.trackedTextAdjust, this.afterSpace, this.afterDelete);
    }

    public TableCell withAlignment(CellAlignment alignment) {
        return new TableCell(this.tableCellNode, this.openMarker, this.text, this.closeMarker, this.rowSpan, this.columnSpan, alignment, this.trackedTextOffset, this.spanTrackedOffset, this.trackedTextAdjust, this.afterSpace, this.afterDelete);
    }

    public TableCell withTrackedOffset(int trackedTextOffset) {
        return new TableCell(this.tableCellNode, this.openMarker, this.text, this.closeMarker, this.rowSpan, this.columnSpan, this.alignment, trackedTextOffset, this.spanTrackedOffset, this.trackedTextAdjust, this.afterSpace, this.afterDelete);
    }

    public TableCell withTrackedOffset(int trackedTextOffset, boolean afterSpace, boolean afterDelete) {
        return new TableCell(this.tableCellNode, this.openMarker, this.text, this.closeMarker, this.rowSpan, this.columnSpan, this.alignment, trackedTextOffset, this.spanTrackedOffset, this.trackedTextAdjust, afterSpace, afterDelete);
    }

    public TableCell withSpanTrackedOffset(int spanTrackedOffset) {
        return new TableCell(this.tableCellNode, this.openMarker, this.text, this.closeMarker, this.rowSpan, this.columnSpan, this.alignment, this.trackedTextOffset, spanTrackedOffset, this.trackedTextAdjust, this.afterSpace, this.afterDelete);
    }

    public TableCell withTrackedTextAdjust(int trackedTextAdjust) {
        return new TableCell(this.tableCellNode, this.openMarker, this.text, this.closeMarker, this.rowSpan, this.columnSpan, this.alignment, this.trackedTextOffset, this.spanTrackedOffset, trackedTextAdjust, this.afterSpace, this.afterDelete);
    }

    public TableCell withAfterSpace(boolean afterSpace) {
        return new TableCell(this.tableCellNode, this.openMarker, this.text, this.closeMarker, this.rowSpan, this.columnSpan, this.alignment, this.trackedTextOffset, this.spanTrackedOffset, this.trackedTextAdjust, afterSpace, this.afterDelete);
    }

    BasedSequence getLastSegment() {
        return !this.closeMarker.isEmpty() ? this.closeMarker : this.text;
    }

    public int getEndOffset() {
        return !this.closeMarker.isEmpty() ? this.closeMarker.getEndOffset() : this.text.getEndOffset();
    }

    public int getStartOffset(TableCell previousCell) {
        return previousCell != null ? previousCell.getEndOffset() : (!this.openMarker.isEmpty() ? this.openMarker.getStartOffset() : this.text.getStartOffset());
    }

    public int getInsideStartOffset(TableCell previousCell) {
        return previousCell != null ? previousCell.getEndOffset() : (!this.openMarker.isEmpty() ? this.openMarker.getEndOffset() : this.text.getStartOffset());
    }

    public int getTextStartOffset(TableCell previousCell) {
        if (!this.text.isEmpty()) {
            return this.text.getStartOffset();
        }
        if (!this.openMarker.isEmpty()) {
            return this.openMarker.getEndOffset() + 1;
        }
        if (previousCell != null) {
            return previousCell.getEndOffset() + 1;
        }
        return this.closeMarker.getStartOffset() - 1;
    }

    public int getTextEndOffset(TableCell previousCell) {
        if (!this.text.isEmpty()) {
            return this.text.getEndOffset();
        }
        if (!this.openMarker.isEmpty()) {
            return this.openMarker.getEndOffset() + 1;
        }
        if (previousCell != null) {
            return previousCell.getEndOffset() + 1;
        }
        return this.closeMarker.getStartOffset() - 1;
    }

    public int getInsideEndOffset() {
        return !this.closeMarker.isEmpty() ? this.closeMarker.getStartOffset() : this.text.getEndOffset();
    }

    public int getCellSize(TableCell previousCell) {
        return this.getEndOffset() - this.getStartOffset(previousCell);
    }

    public int insideToTextOffset(int insideOffset, TableCell previousCell) {
        return Utils.maxLimit(this.text.length(), Utils.minLimit(insideOffset - this.getInsideStartOffset(previousCell) + this.getTextStartOffset(previousCell), 0));
    }

    public int textToInsideOffset(int insideOffset, TableCell previousCell) {
        return Utils.maxLimit(this.getCellSize(previousCell), Utils.minLimit(insideOffset - this.getTextStartOffset(previousCell) + this.getInsideStartOffset(previousCell), 0));
    }

    public boolean isInsideCell(int offset, TableCell previousCell) {
        return offset >= this.getInsideStartOffset(previousCell) && offset <= this.getInsideEndOffset();
    }

    public boolean isAtCell(int offset, TableCell previousCell) {
        return offset >= this.getInsideStartOffset(previousCell) && offset <= this.getInsideEndOffset();
    }

    public int getCellLength(TableCell previousCell) {
        return this.getEndOffset() - this.getStartOffset(previousCell);
    }

    public int getCellPrefixLength(TableCell previousCell) {
        return this.getInsideStartOffset(previousCell) - this.getStartOffset(previousCell);
    }

    private CharSequence dumpSequence(BasedSequence sequence) {
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"").append((CharSequence)sequence.replace("\"", "\\\"")).append("\"").append(" [").append(sequence.getStartOffset()).append(", ").append(sequence.getEndOffset()).append("), length=").append(sequence.length()).append("}");
        return sb;
    }

    public String toString() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1) + "{openMarker=" + this.dumpSequence(this.openMarker) + ", text=" + this.dumpSequence(this.text) + ", closeMarker=" + this.dumpSequence(this.closeMarker) + ", columnSpan=" + this.columnSpan + ", rowSpan=" + this.rowSpan + ", alignment=" + (Object)((Object)this.alignment) + ", trackedTextOffset=" + this.trackedTextOffset + ", spanTrackedOffset=" + this.spanTrackedOffset + ", trackedTextAdjust=" + this.trackedTextAdjust + ", afterSpace=" + this.afterSpace + ", afterDelete=" + this.afterDelete + '}';
    }
}

